/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.logger;

import io.gitlab.jfronny.commons.logger.CompactLogger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class MemoryLogger
implements CompactLogger,
Iterable<String> {
    private final String name;
    private final List<String> lines;
    private final int size;
    private final System.Logger.Level level;

    public MemoryLogger(String name, System.Logger.Level level) {
        this.name = Objects.requireNonNull(name);
        this.lines = new LinkedList<String>();
        this.size = -1;
        this.level = Objects.requireNonNull(level);
    }

    public MemoryLogger(String name, System.Logger.Level level, int size) {
        this.name = Objects.requireNonNull(name);
        this.lines = new ArrayList<String>(size);
        this.size = size;
        this.level = Objects.requireNonNull(level);
    }

    @Override
    public System.Logger.Level getLevel() {
        return this.level;
    }

    @Override
    public void log(System.Logger.Level level, String message) {
        if (!this.isLoggable(level)) {
            return;
        }
        this.add("[" + (switch (level) {
            case System.Logger.Level.TRACE -> "T";
            case System.Logger.Level.DEBUG -> "D";
            case System.Logger.Level.INFO -> "I";
            case System.Logger.Level.WARNING -> "W";
            case System.Logger.Level.ERROR -> "E";
            default -> "I";
        }) + "] " + message);
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(String msg) {
        List<String> list = this.lines;
        synchronized (list) {
            int lz = this.lines.size();
            if (this.size != -1 && lz >= this.size - 1) {
                Iterator<String> iterator = this.lines.iterator();
                int max = lz - this.size + 1;
                for (int i = 0; i < max; ++i) {
                    iterator.remove();
                }
            }
            this.lines.add(msg);
        }
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return this.lines.iterator();
    }

    @Override
    public void forEach(Consumer<? super String> action) {
        this.lines.forEach(action);
    }

    @Override
    public Spliterator<String> spliterator() {
        return this.lines.spliterator();
    }
}

